import pandas as pd  
from sklearn.cluster import KMeans 
from sklearn.metrics import silhouette_score 
import matplotlib.pyplot as plt
from decision_company import read_csv_file, create_kmeans, fit_predict_kmeans, get_silhouette_score, show_plots, create_figure, set_plot_title, set_yaxis_label, set_plot_xlabel, save_plot, plot, grid

  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Determine the sum of squared distances for different number of clusters  
# Calculate silhouette scores for different number of clusters  
silhouette_scores = []  
  
for cluster_num in range(2, 15):  # Starting from 2 because silhouette score is not defined for 1 cluster  
    kmeans = create_kmeans(n_clusters=cluster_num, random_state=42)  
    cluster_labels = fit_predict_kmeans(kmeans, data_for_clustering_scaled)  
    silhouette_avg = get_silhouette_score(data_for_clustering_scaled, cluster_labels)  
    silhouette_scores.append(silhouette_avg)  
  
# Plot silhouette scores  
create_figure(figsize=(10, 6))  
plot(range(2, 15), silhouette_scores, marker='o', linestyle='--')  
set_plot_title('Silhouette Scores for Different Number of Clusters')  
set_plot_xlabel('Number of Clusters')  
set_yaxis_label('Silhouette Score')  
grid(True)  
save_plot('ref_result/Silhouette_Scores.png')  
show_plots() 